/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.dom.Application;
import org.autoplot.dom.Axis;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.ChangesSupport;
import org.autoplot.dom.DataSourceController;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PlotElementController;
import org.autoplot.util.TickleTimer;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DateTimeDatumFormatter;
import org.das2.datum.format.DatumFormatter;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;

public class TimeSeriesBrowseController {
    private PlotElement p;
    private DasAxis xAxis;
    private boolean released = false;
    private DasPlot dasPlot;
    private Plot plot;
    private PlotElementController plotElementController;
    private final DataSourceController dataSourceController;
    private DataSourceFilter dsf;
    private ChangesSupport changesSupport;
    private static final String PENDING_AXIS_DIRTY = "tsbAxisDirty";
    private static final String PENDING_TIMERANGE_DIRTY = "tsbTimerangeDirty";
    private static final String PENDING_AXIS_OR_TIMERANGE_DIRTY = "tsbAxisOrTimerangeDirty";
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.tsb");
    TickleTimer updateTsbTimer;
    PropertyChangeListener timeSeriesBrowseListener;
    private DomNode listenNode = null;
    private String listenProp = null;
    protected DatumRange timeRange = null;
    public static final String PROP_TIMERANGE = "timeRange";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private static List<Axis> getTimerangeBoundAxes(Application dom) {
        List<BindingModel> bms = DomUtil.findBindings(dom, dom, PROP_TIMERANGE);
        ArrayList<Axis> result = new ArrayList<Axis>();
        for (BindingModel bm : bms) {
            if (!bm.getDstProperty().equals("range")) continue;
            result.add((Axis)DomUtil.getElementById(dom, bm.getDstId()));
        }
        return result;
    }

    private static List<Axis> getOtherBoundAxes(Application dom, Axis axis) {
        List<BindingModel> bms = DomUtil.findBindings(dom, axis, "range");
        ArrayList<Axis> result = new ArrayList<Axis>();
        for (BindingModel bm : bms) {
            DomNode n;
            if (bm.getSrcProperty().equals(PROP_TIMERANGE)) {
                result.addAll(TimeSeriesBrowseController.getTimerangeBoundAxes(dom));
                continue;
            }
            if (bm.getSrcId().equals(axis.getId())) {
                n = DomUtil.getElementById(dom, bm.getDstId());
                if (!(n instanceof Axis)) continue;
                result.add((Axis)n);
                continue;
            }
            if (!bm.getDstId().equals(axis.getId()) || !((n = DomUtil.getElementById(dom, bm.getSrcId())) instanceof Axis)) continue;
            result.add((Axis)n);
        }
        return result;
    }

    protected TimeSeriesBrowseController(DataSourceController dataSourceController, final PlotElement p) {
        this.changesSupport = new ChangesSupport(this.propertyChangeSupport, this);
        this.updateTsbTimer = new TickleTimer(300L, new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DataSourceController dsc;
                DataSourceFilter dsf;
                PlotElementController pec;
                TimeSeriesBrowse ftsb;
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"updateTsbTimer");
                if (TimeSeriesBrowseController.this.dsf == null) {
                    return;
                }
                Application dom = TimeSeriesBrowseController.this.dsf.getController().getApplication();
                if (TimeSeriesBrowseController.this.plot != null) {
                    List otherAxes = TimeSeriesBrowseController.getOtherBoundAxes(dom, TimeSeriesBrowseController.this.plot.getXaxis());
                    for (Axis a : otherAxes) {
                        if (!a.getController().getDasAxis().valueIsAdjusting()) continue;
                        TimeSeriesBrowseController.this.updateTsbTimer.tickle();
                        logger.log(Level.FINEST, "{0} is adjusting", a);
                        return;
                    }
                }
                PlotElement fpe = p;
                DataSourceFilter fdsf = p != null ? p.getController().getDataSourceFilter() : null;
                TimeSeriesBrowse timeSeriesBrowse = ftsb = fdsf != null ? fdsf.getController().getTsb() : null;
                if (dom.getController().isValueAdjusting()) {
                    TimeSeriesBrowseController.this.updateTsbTimer.tickle();
                    logger.log(Level.FINEST, "applicationController is adjusting");
                    return;
                }
                HashMap<Object, Object> changes = new HashMap<Object, Object>();
                if (fpe != null && (pec = fpe.getController()) != null && (dsf = pec.getDataSourceFilter()) != null && (dsc = dsf.getController()) != null) {
                    dsc.pendingChanges(changes);
                    changes.remove(TimeSeriesBrowseController.PENDING_AXIS_OR_TIMERANGE_DIRTY);
                }
                if (fpe != null && !changes.isEmpty()) {
                    logger.log(Level.FINEST, "DataSourceFilter is already pending changes, retickle");
                    TimeSeriesBrowseController.this.updateTsbTimer.tickle();
                    return;
                }
                try {
                    TimeSeriesBrowseController.this.changesSupport.performingChange(TimeSeriesBrowseController.this, TimeSeriesBrowseController.PENDING_AXIS_OR_TIMERANGE_DIRTY);
                    if (fpe != null) {
                        if (fdsf == null) return;
                        if (ftsb == null) {
                            return;
                        }
                    }
                    if (TimeSeriesBrowseController.this.released) {
                        logger.fine("leftover update ignored because this is released.");
                        return;
                    }
                    TimeSeriesBrowseController.this.updateTsb(false);
                    return;
                }
                finally {
                    TimeSeriesBrowseController.this.changesSupport.changePerformed(TimeSeriesBrowseController.this, TimeSeriesBrowseController.PENDING_AXIS_OR_TIMERANGE_DIRTY);
                }
            }
        });
        this.dsf = dataSourceController.dsf;
        this.dataSourceController = dataSourceController;
        if (p != null) {
            this.p = p;
            this.plot = this.dsf.getController().getApplication().getController().getPlotFor(p);
            this.plotElementController = p.getController();
        } else {
            logger.fine("no plotElement provided, better come back to set up from timerange.");
        }
        if (p != null) {
            this.dasPlot = this.plotElementController.getDasPlot();
            this.xAxis = this.plotElementController.getDasPlot().getXAxis();
        }
    }

    private boolean isBoundTimeRange(BindingModel[] bms, String dstId) {
        for (int i = 0; i < bms.length; ++i) {
            if (!bms[i].getSrcProperty().equals(PROP_TIMERANGE) || !bms[i].getDstProperty().equals("range") || bms[i].getDstId().equals(dstId)) continue;
            return true;
        }
        return false;
    }

    protected void setupAxis(Plot plot, Axis axis) {
        if (this.xAxis != null) {
            throw new IllegalArgumentException("release old axis before binding to this new axis");
        }
        if (axis != plot.getXaxis()) {
            throw new IllegalArgumentException("axis must be the x-axis for now.");
        }
        this.xAxis = axis.getController().getDasAxis();
        this.dasPlot = plot.getController().getDasPlot();
        this.plot = plot;
        this.setup(true);
    }

    protected void setupGen(DomNode node, final String property) {
        logger.entering("TimeSeriesBrowseController", "setupGen");
        this.timeSeriesBrowseListener = new PropertyChangeListener(){

            public String toString() {
                return "" + TimeSeriesBrowseController.this;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"timeSeriesBrowseListener");
                if (evt.getPropertyName().equals(property)) {
                    TimeSeriesBrowseController.this.changesSupport.registerPendingChange(TimeSeriesBrowseController.this, TimeSeriesBrowseController.PENDING_AXIS_OR_TIMERANGE_DIRTY);
                    DatumRange dr = (DatumRange)evt.getNewValue();
                    if (UnitsUtil.isTimeLocation((Units)dr.getUnits())) {
                        TimeSeriesBrowseController.this.setTimeRange(dr);
                    } else {
                        TimeSeriesBrowseController.this.release();
                    }
                    TimeSeriesBrowseController.this.updateTsbTimer.tickle();
                }
            }
        };
        if (!DomUtil.nodeHasProperty(node, property)) {
            throw new IllegalArgumentException("node " + node + " doesn't have property: " + property);
        }
        try {
            Class<?> c = node.getClass();
            PropertyDescriptor pd = new PropertyDescriptor(property, c);
            Method getter = pd.getReadMethod();
            DatumRange defaultTimeRange = this.dsf.getController().getTsb().getTimeRange();
            DatumRange appTimeRange = (DatumRange)getter.invoke((Object)node, new Object[0]);
            logger.log(Level.FINER, "using app time range: {0}", appTimeRange);
            if (!appTimeRange.equals((Object)Application.DEFAULT_TIME_RANGE) && UnitsUtil.isTimeLocation((Units)appTimeRange.getUnits())) {
                this.setTimeRange(appTimeRange);
                this.dsf.getController().getTsb().setTimeRange(appTimeRange);
            } else {
                this.setTimeRange(defaultTimeRange);
                pd.getWriteMethod().invoke((Object)node, defaultTimeRange);
            }
            node.addPropertyChangeListener(property, this.timeSeriesBrowseListener);
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.listenNode = node;
        this.listenProp = property;
        this.released = false;
        logger.exiting("TimeSeriesBrowseController", "setupGen");
    }

    protected void setup(boolean valueWasAdjusting) {
        boolean setTsbInitialResolution;
        DatumRange localTimeRange;
        logger.log(Level.FINE, "setup({0})", valueWasAdjusting);
        TimeSeriesBrowse tsb = this.dataSourceController.getTsb();
        DatumRange datumRange = localTimeRange = tsb == null ? null : tsb.getTimeRange();
        if (this.p != null && !valueWasAdjusting) {
            if (localTimeRange == null) {
                logger.warning("localTimeRange is null, leaving");
                return;
            }
            this.xAxis.setDatumRange(localTimeRange);
            this.plot.getXaxis().setAutoRange(false);
        }
        if (setTsbInitialResolution = true) {
            try {
                this.changesSupport.performingChange(this, PENDING_AXIS_DIRTY);
                DatumRange tr = localTimeRange;
                if (tr == null) {
                    tr = this.plot.getXaxis().getRange();
                }
                this.setTimeRange(tr);
                if (this.plot.getXaxis().isAutoRange() && !valueWasAdjusting) {
                    BindingModel[] bms = this.dsf.getController().getApplication().getBindings();
                    DatumRange appRange = this.dsf.getController().getApplication().getTimeRange();
                    if (appRange.getUnits().isConvertibleTo(tr.getUnits()) && this.isBoundTimeRange(bms, this.plot.getXaxis().getId())) {
                        this.dasPlot.getXAxis().resetRange(appRange);
                    } else {
                        this.dasPlot.getXAxis().resetRange(tr);
                    }
                    if (!this.dasPlot.getXAxis().getLabel().contains("%{RANGE}")) {
                        this.dasPlot.getXAxis().setUserDatumFormatter((DatumFormatter)new DateTimeDatumFormatter(this.dsf.getController().getApplication().getOptions().isDayOfYear() ? 1 : 0));
                    }
                    this.plot.getXaxis().setAutoRange(true);
                    this.dasPlot.getXAxis().setScanRange(null);
                }
                this.updateTsb(true);
            }
            catch (RuntimeException e) {
                throw e;
            }
            finally {
                this.changesSupport.changePerformed(this, PENDING_AXIS_DIRTY);
            }
        }
        this.timeSeriesBrowseListener = new PropertyChangeListener(){

            public String toString() {
                return "" + TimeSeriesBrowseController.this;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DatumRange dr;
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"timeSeriesBrowseListener");
                if (TimeSeriesBrowseController.this.dasPlot == null) {
                    return;
                }
                if (TimeSeriesBrowseController.this.dasPlot.getXAxis().valueIsAdjusting()) {
                    return;
                }
                if (evt.getPropertyName().equals("datumRange")) {
                    DatumRange dr2 = (DatumRange)evt.getNewValue();
                    if (UnitsUtil.isTimeLocation((Units)dr2.getUnits())) {
                        TimeSeriesBrowseController.this.changesSupport.registerPendingChange(TimeSeriesBrowseController.this, TimeSeriesBrowseController.PENDING_AXIS_OR_TIMERANGE_DIRTY);
                        logger.log(Level.FINE, "setTimeRange({0}) because of datumRange", dr2);
                        TimeSeriesBrowseController.this.setTimeRange(dr2);
                        TimeSeriesBrowseController.this.updateTsbTimer.tickle();
                    }
                } else if (evt.getPropertyName().equals("context") && UnitsUtil.isTimeLocation((Units)(dr = (DatumRange)evt.getNewValue()).getUnits())) {
                    TimeSeriesBrowseController.this.changesSupport.registerPendingChange(TimeSeriesBrowseController.this, TimeSeriesBrowseController.PENDING_AXIS_OR_TIMERANGE_DIRTY);
                    logger.log(Level.FINE, "setTimeRange({0}) because of context", dr);
                    TimeSeriesBrowseController.this.setTimeRange(dr);
                    TimeSeriesBrowseController.this.updateTsbTimer.tickle();
                }
            }
        };
        this.dasPlot.getXAxis().addPropertyChangeListener("datumRange", this.timeSeriesBrowseListener);
        this.plot.addPropertyChangeListener("context", this.timeSeriesBrowseListener);
        this.released = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateTsb(boolean autorange) {
        CacheTag testCacheTag;
        Datum newResolution;
        CacheTag tag;
        DatumRange trange;
        block20: {
            block19: {
                logger.log(Level.FINE, "updateTsb({0})...", autorange);
                trange = this.getTimeRange();
                if (trange == null) return;
                QDataSet ds = this.dataSourceController.getDataSet();
                QDataSet dep0 = ds == null ? null : (QDataSet)ds.property("DEPEND_0");
                Object join0 = ds == null ? null : ds.property("JOIN_0");
                CacheTag cacheTag = tag = dep0 == null ? null : (CacheTag)dep0.property("CACHE_TAG");
                if (tag == null && join0 != null) {
                    if (join0 instanceof QDataSet) {
                        QDataSet qdsj = (QDataSet)join0;
                        tag = (CacheTag)qdsj.property("CACHE_TAG");
                    } else {
                        logger.log(Level.FINE, "join property was not a QDataSet: {0}", join0.toString());
                    }
                }
                newResolution = null;
                if (this.xAxis == null) break block19;
                DatumRange visibleRange = this.xAxis.getDatumRange();
                if (this.xAxis.getDLength() > 2) {
                    newResolution = visibleRange.width().divide((double)this.xAxis.getDLength());
                } else {
                    Canvas c = this.dataSourceController.getApplication().getCanvases(0);
                    this.xAxis.getCanvas().setSize(c.width, c.height);
                    if (this.xAxis.getDLength() <= 2) {
                        logger.warning("xaxis isn't sized, loading data at full resolution!");
                    } else {
                        newResolution = visibleRange.width().divide((double)this.xAxis.getDLength());
                    }
                }
                DatumRange newRange = visibleRange;
                testCacheTag = new CacheTag(DatumRangeUtil.rescale((DatumRange)newRange, (double)0.01, (double)0.99), newResolution);
                trange = newRange;
                if (!UnitsUtil.isTimeLocation((Units)visibleRange.getUnits())) {
                    logger.log(Level.FINE, "x-axis for TSB not time location units: {0}", visibleRange);
                    trange = this.dsf.getController().getApplication().getTimeRange();
                    if (!UnitsUtil.isTimeLocation((Units)trange.getUnits())) {
                        logger.fine("  unable to bind to application timeRange because of units.");
                        return;
                    }
                    logger.fine("  rebinding application timeRange");
                    this.release();
                    this.setupGen(this.plot, "context");
                    Application dom = this.plot.getController().getApplication();
                    if (!dom.getController().isPendingChanges()) {
                        dom.getController().bind(dom, PROP_TIMERANGE, this.plot, "context");
                    }
                }
                break block20;
            }
            testCacheTag = new CacheTag(trange, null);
        }
        if (!UnitsUtil.isTimeLocation((Units)testCacheTag.getRange().getUnits())) {
            testCacheTag = new CacheTag(this.getTimeRange(), null);
        }
        if (tag == null || (this.xAxis == null ? !tag.equals(testCacheTag) : !tag.contains(testCacheTag))) {
            TimeSeriesBrowse tsb = this.dataSourceController.getTsb();
            if (tsb == null) {
                logger.warning("tsbc253: tsb was null");
                return;
            }
            if (this.xAxis != null) {
                tsb.setTimeRange(trange);
                tsb.setTimeResolution(newResolution);
                logger.log(Level.FINE, "updateTsb: {0} (@{1})", new Object[]{trange, newResolution});
            } else {
                tsb.setTimeRange(trange);
                tsb.setTimeResolution(null);
                logger.log(Level.FINE, "updateTsb: {0} (@ intrinsic)", trange);
            }
            String surl = tsb.getURI();
            if (!autorange && surl.equals(this.dataSourceController.getTsbSuri())) {
                logger.fine("we do no better with tsb");
                if (this.xAxis != null) return;
                return;
            }
            if (!surl.equals(this.dataSourceController.getTsbSuri())) {
                logger.log(Level.FINER, "update b/c surl!=tsbSuri:\n  {0}\n  {1}", new Object[]{surl, this.dataSourceController.getTsbSuri()});
            }
            this.dataSourceController.cancel();
            logger.fine("calling update, which will reload data");
            if (this.released) {
                System.err.append("here were shouldn't be");
            }
            this.dataSourceController.update(false);
            this.dataSourceController.setTsbSuri(surl);
            if (this.plot == null) return;
            String uriMode = "reset";
            if (uriMode.equals("blur")) {
                String newUri = DataSetURI.blurTsbUri((String)surl);
                if (newUri == null) return;
                this.dataSourceController.dsf.uri = newUri;
                this.plot.controller.dom.controller.setFocusUri(newUri);
                return;
            }
            if (!uriMode.equals("reset")) return;
            String newUri = DataSetURI.blurTsbResolutionUri((String)surl);
            if (newUri == null) return;
            this.dataSourceController.dsf.uri = newUri;
            this.plot.controller.dom.controller.setFocusUri(newUri);
            return;
        }
        logger.fine("loaded dataset satifies request");
    }

    private PlotElement getPlotElement() {
        return this.p;
    }

    public boolean isPendingChanges() {
        if (this.changesSupport.isPendingChanges()) {
            return true;
        }
        return this.changesSupport.isPendingChanges();
    }

    public void pendingChanges(Map<Object, Object> c) {
        c.putAll(this.changesSupport.changesPending);
    }

    protected void release() {
        if (this.isListeningToAxis()) {
            logger.fine("releasing TSB controller");
            this.dasPlot.getXAxis().removePropertyChangeListener("datumRange", this.timeSeriesBrowseListener);
            this.plot.removePropertyChangeListener("context", this.timeSeriesBrowseListener);
            this.xAxis = null;
            this.released = true;
        } else if (this.listenNode != null) {
            if (this.timeSeriesBrowseListener == null) {
                logger.fine("here timeSeriesBrowseListener is null");
            }
            this.listenNode.removePropertyChangeListener(this.listenProp, this.timeSeriesBrowseListener);
        }
        this.timeSeriesBrowseListener = null;
    }

    protected void releaseAll() {
        this.release();
        this.plot = null;
        this.xAxis = null;
        this.dasPlot = null;
        this.dsf = null;
        if (this.listenNode != null) {
            this.listenNode.removePropertyChangeListener(this.listenProp, this.timeSeriesBrowseListener);
            this.listenNode = null;
        }
        this.plotElementController = null;
        this.dataSourceController.releaseTimeSeriesBrowseController();
        this.released = true;
    }

    private DatumRange getTimeRange() {
        return this.timeRange;
    }

    private void setTimeRange(DatumRange timeRange) {
        if (!UnitsUtil.isTimeLocation((Units)timeRange.getUnits())) {
            logger.log(Level.FINE, "ignoring call to setTimeRange with non-time-location {0}", timeRange);
            return;
        }
        DatumRange oldTimeRange = this.timeRange;
        this.timeRange = timeRange;
        this.propertyChangeSupport.firePropertyChange(PROP_TIMERANGE, oldTimeRange, timeRange);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public String toString() {
        return this.dsf + " timeSeriesBrowse controller";
    }

    public boolean isListeningToAxis() {
        return this.xAxis != null;
    }

    public String getPlotId() {
        return this.plot.getId();
    }

    Plot getPlot() {
        return this.plot;
    }
}

